#define F_CPU 8000000UL

#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdio.h>
#include <stdint.h>
#include <avr/eeprom.h>

#define __delay_cycles(n)     __builtin_avr_delay_cycles(n)
#define __enable_interrupt()  sei()
#define _DEBUG_INTERFACE_

#include "touch_api.h"
#include "touch.h"
#include "uart.h"

/*----------------------------------------------------------------------------
                            manifest constants
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
                                    macros
----------------------------------------------------------------------------*/

#define GET_SENSOR_STATE(SENSOR_NUMBER) qt_measure_data.qt_touch_status.sensor_states[(SENSOR_NUMBER/8)] & (1 << (SENSOR_NUMBER % 8))
#define GET_ROTOR_SLIDER_POSITION(ROTOR_SLIDER_NUMBER) qt_measure_data.qt_touch_status.rotor_slider_values[ROTOR_SLIDER_NUMBER]

#define QT_NUM_CHANNELS 8
/*----------------------------------------------------------------------------
                            type definitions
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
                                prototypes
----------------------------------------------------------------------------*/
extern void touch_measure();
extern void touch_init( void );
extern void init_system( void );
extern void init_timer_isr(void);
extern void set_timer_period(uint16_t);
/*----------------------------------------------------------------------------
                            Structure Declarations
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
                                    macros
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
                                global variables
----------------------------------------------------------------------------*/
/* Timer period in msec. */
uint16_t qt_measurement_period_msec = QT_MEASUREMENT_PERIOD_MS;
uint16_t time_ms_inc=0;
/*----------------------------------------------------------------------------
                                extern variables
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
                                static variables
----------------------------------------------------------------------------*/

/* flag set by timer ISR when it's time to measure touch */
volatile uint8_t time_to_measure_touch = 0u;

/* current time, set by timer ISR */
volatile uint16_t current_time_ms_touch = 0u;

uint8_t state, prev_state = 12;
uint16_t sensor_read,volume,tempo;
bool no_detect;
/*============================================================================
Name    :   main
------------------------------------------------------------------------------
Purpose :   main code entry point
Input   :   n/a
Output  :   n/a
Notes   :
============================================================================*/

unsigned long int loop=0;

int main (void)
{
   /* initialise host app, pins, watchdog, etc */
    init_system();

    /* configure timer ISR to fire regularly */
    init_timer_isr();

	/* Initialize Touch sensors */
	touch_init();
  
	 //init the UART -- uart_init() is in uart.c
	uart_init();
	FILE uart_output = FDEV_SETUP_STREAM(uart_putchar, NULL, _FDEV_SETUP_WRITE);
	FILE uart_input = FDEV_SETUP_STREAM(NULL, uart_getchar, _FDEV_SETUP_READ);

	stdout = &uart_output;
	stdin  = &uart_input;

	puts ("Keypad Connection Testing...\n");
	
    /* loop forever */
    for( ; ; )
    {
		
		
		touch_measure();	
		/*  Time Non-critical host application code goes here  */
//////////////////////////////////////	
		if (GET_SENSOR_STATE(0))
		{
			if (prev_state != 0x08)
			{
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 0x08;
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 0x08;
				state= 8;
			//	printf("%i\n", state);
				prev_state = 8;				
			}					
		}
		if (GET_SENSOR_STATE(1))
		{
			if (prev_state != 3)
			{
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 0x03;
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 0x03;
				state= 3;
			//	printf("%i\n", state);
				prev_state = 3;
			}					
		}		
		if (GET_SENSOR_STATE(2))
		{
			if (prev_state != 7)
			{
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 7;
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 7;
				state = 7;
				//printf("%i\n", state);
				prev_state = 7;
			}
		}
		if (GET_SENSOR_STATE(3))
		{
			if (prev_state != 11)
			{
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 11;
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 11;
				state= 11;
				//printf("%i\n", state);
				prev_state = 11;
			}
		}

		if (GET_SENSOR_STATE(4))
		{
			if (prev_state != 4)
			{
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 0x04;
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 0x04;
				state= 4;
				//printf("%i\n", state);
				prev_state = 4;
			}
		}
		if (GET_SENSOR_STATE(5))
		{
			if (prev_state != 2)
			{
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 2;
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 2;
				state= 2;
				//printf("%i\n", state);
				prev_state = 2;
			}
		}
		if (GET_SENSOR_STATE(6))
		{
			if (prev_state != 6)
			{
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 6;
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 =6;
				state= 6;
				//printf("%i\n", state);
				prev_state = 6;
			}
		}
		if (GET_SENSOR_STATE(7))
		{
			if (prev_state != 10)
			{
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 10;
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 10;
				state= 10;
				//printf("%i\n", state);
				prev_state = 10;
			}
		}
		if (GET_SENSOR_STATE(8))
		{
			if (prev_state != 0)
			{
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 0;
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 0;
				state= 0;
				//printf("%i\n", state);
				prev_state = 0;		
			}
		}
		if (GET_SENSOR_STATE(9))
		{
			if (prev_state != 9)
			{
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 9;
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 9;
				state= 9;
				//printf("%i\n", state);
				prev_state = 9;
			}
		}
		if (GET_SENSOR_STATE(10))
		{
			if (prev_state != 1)
			{
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 1;
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 1;
				state= 1;
				//printf("%i\n", state);
				prev_state = 1;
			}
		}
		if (GET_SENSOR_STATE(11))
		{
			if (prev_state != 5)
			{
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 5;
				loop_until_bit_is_set(UCSR0A, UDRE0);
				UDR0 = 5;
				
				state= 5;
				//printf("%i\n", state);
				prev_state = 5;
			}			
				
		}
		if (qt_measure_sensors(current_time_ms_touch) == 0x0000)
		{
			prev_state = 12;
		}		
														
	}
}

